/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.mixin.models.cullshape;

import ca.fxco.moreculling.api.model.BakedOpacity;
import ca.fxco.moreculling.api.model.CullShapeElement;
import ca.fxco.moreculling.api.model.ExtendedUnbakedModel;
import ca.fxco.moreculling.utils.ShapeUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.math.Transformation;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockModel.class})
public abstract class BlockModel_cullShapeMixin
implements ExtendedUnbakedModel {
    @Shadow
    @Nullable
    protected BlockModel parent;
    @Unique
    @Nullable
    private List<CullShapeElement> moreculling$cullShapeElements = null;
    @Unique
    private boolean moreculling$useModelShape = false;

    @Shadow
    public abstract List<BlockElement> getElements();

    @Override
    public void moreculling$setCullShapeElements(@Nullable List<CullShapeElement> cullShapeElements) {
        this.moreculling$cullShapeElements = cullShapeElements;
    }

    @Override
    @Nullable
    public List<CullShapeElement> moreculling$getCullShapeElements(ResourceLocation id) {
        if (this.moreculling$cullShapeElements == null) {
            return this.parent != null ? ((ExtendedUnbakedModel)this.parent).moreculling$getCullShapeElements(id) : null;
        }
        return this.moreculling$cullShapeElements;
    }

    @Override
    public void moreculling$setUseModelShape(boolean useModelShape) {
        this.moreculling$useModelShape = useModelShape;
    }

    @Override
    public boolean moreculling$getUseModelShape(ResourceLocation id) {
        return this.moreculling$useModelShape;
    }

    @Override
    public BlockElementFace moreculling$modifyElementFace(BlockElementFace elementFace) {
        return elementFace;
    }

    @Redirect(method={"<clinit>"}, at=@At(value="INVOKE", target="Lcom/google/gson/GsonBuilder;create()Lcom/google/gson/Gson;"))
    private static Gson moreculling$registerCustomTypeAdapter(GsonBuilder builder) {
        return builder.registerTypeAdapter(CullShapeElement.class, (Object)new CullShapeElement.Deserializer()).create();
    }

    @Redirect(method={"bake(Lnet/minecraft/client/resources/model/ModelBaker;Lnet/minecraft/client/renderer/block/model/BlockModel;Ljava/util/function/Function;Lnet/minecraft/client/resources/model/ModelState;Z)Lnet/minecraft/client/resources/model/BakedModel;", "bakeVanilla"}, at=@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;"))
    private Object moreculling$overrideFaceData(Map<Direction, BlockElementFace> map, Object direction) {
        return this.moreculling$modifyElementFace(map.get((Direction)direction));
    }

    @Inject(method={"bake(Lnet/minecraft/client/resources/model/ModelBaker;Lnet/minecraft/client/renderer/block/model/BlockModel;Ljava/util/function/Function;Lnet/minecraft/client/resources/model/ModelState;Z)Lnet/minecraft/client/resources/model/BakedModel;"}, at={@At(value="RETURN")})
    private void moreculling$onBake(ModelBaker baker, BlockModel parent, Function<Material, TextureAtlasSprite> textureGetter, ModelState settings, boolean hasDepth, CallbackInfoReturnable<BakedModel> cir) {
        BakedModel bakedModel = (BakedModel)cir.getReturnValue();
        if (bakedModel == null) {
            return;
        }
        BakedOpacity bakedOpacity = (BakedOpacity)bakedModel;
        if (!bakedOpacity.moreculling$canSetCullingShape()) {
            return;
        }
        ResourceLocation id = parent.parentLocation;
        if (this.moreculling$getUseModelShape(id)) {
            List<BlockElement> modelElementList = this.getElements();
            if (modelElementList != null && !modelElementList.isEmpty()) {
                Object voxelShape = Shapes.empty();
                for (BlockElement e : modelElementList) {
                    if (e.rotation != null && e.rotation.angle() != 0.0f || !(e.from.x <= e.to.x) || !(e.from.y <= e.to.y) || !(e.from.z <= e.to.z)) continue;
                    VoxelShape shape = Block.box((double)e.from.x, (double)e.from.y, (double)e.from.z, (double)e.to.x, (double)e.to.y, (double)e.to.z);
                    voxelShape = ShapeUtils.orUnoptimized(voxelShape, shape);
                }
                if (settings.getRotation() != Transformation.identity()) {
                    Direction direction = Direction.rotate((Matrix4f)settings.getRotation().getMatrix(), (Direction)Direction.NORTH);
                    voxelShape = direction.getAxis() != Direction.Axis.Y ? ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, direction, voxelShape) : null;
                }
                bakedOpacity.moreculling$setCullingShape((VoxelShape)voxelShape);
                return;
            }
        } else {
            List<CullShapeElement> cullShapeElementList = this.moreculling$getCullShapeElements(id);
            if (cullShapeElementList != null && !cullShapeElementList.isEmpty()) {
                VoxelShape voxelShape = Shapes.empty();
                for (CullShapeElement e : cullShapeElementList) {
                    VoxelShape shape = Block.box((double)e.from.x, (double)e.from.y, (double)e.from.z, (double)e.to.x, (double)e.to.y, (double)e.to.z);
                    voxelShape = ShapeUtils.orUnoptimized(voxelShape, shape);
                }
                bakedOpacity.moreculling$setCullingShape(voxelShape);
                return;
            }
        }
        bakedOpacity.moreculling$setCullingShape(null);
    }
}

